<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Certification extends Model
{
    protected $table = 'certifications';
    protected $primaryKey = 'Certification_id';
    public $timestamps = false; // Only Created_at, not Updated_at

    protected $fillable = [
        'User_id',
        'Course_id',
        'Certificate_url',
        'Issue_date',
        'Expiry_date',
        'Created_at',
        'Verification_code',
        'Serial_number',
        'Status',
        'Certificate_version',
        'LinkedIn_shared', // Added
    ];

    protected $casts = [
        'Issue_date' => 'date',
        'Expiry_date' => 'date',
        'Created_at' => 'datetime',
        'Status' => 'string',
        'LinkedIn_shared' => 'boolean', // Added
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
    }
}
